{$A+,B-,D+,E+,F-,I+,L+,N-,O-,R-,S-,V-}
{$M 4096,0,650000}
{	Exemple d'utilisation de SoundDRV en pascal 6.0
 	Par F. Bellard pour ESAT Software
	TAB=3 SPACES
}
program Play_Mod;

uses dos,crt,SoundDRV;

const
	onpcstr:array[0..2] of string[3]=('no','yes','???');

type
	tab=array[0..65000] of byte;

const
	StateLine=10;

var
	Module:TRPMmodule;
	DSinfo:TDSoundInfo;
	RS:TRPMStatus;
	CGINF:TCardGlobalInfo;
	CINF:TCardInfo;
     err:integer;
	fin,v,i,j:integer;
	ctype,freq,k:word;
	nommod:string[80];

{ durant la mise au point, cette fonction peut servir ! }
function hex(a:word):string;
const ref:array[0..15] of char='0123456789ABCDEF';
begin
	hex:=ref[hi(a) shr 4]+ref[hi(a) and $F]+ref[lo(a) shr 4]+ref[lo(a) and $F];
end;

{ on va sous dos en librant avant la RAM inutile au dessus du module }
procedure DosShell;
var reg:registers;
begin
     reg.AH:=$4A;
     reg.ES:=prefixseg;
     reg.BX:=seg(heapptr^)-prefixseg+2;
     msdos(reg);
     SwapVectors;
     Exec(GetEnv('COMSPEC'),'');
     SwapVectors;
	if DosError<>0 then begin
		writeln('Error while loading command.com');
	end;
end;

{	fonction keypressed n'interfrant pas avec celle du bios. Cela est utile
	lors de l'utilisation du haut parleur. Cela vite d'entendre quelques
	grsillements sur certains PC
}
function keypressed:boolean;
begin
     keypressed:=(memW[$40:$1A]<>memW[$40:$1C]) and crt.keypressed;
end;

{	comme readkey, mais renvoie un word qui contient un code de touche
	complet.
}
function getkey:word; assembler;
asm
	mov ah,0
	int 16h
	or al,al
	je @1
	mov ah,0
@1:
end;


procedure Error(s:string);
begin
	writeln('Fatal: ',s);
	halt(1);
end; 

function fstr(a:longint;n:integer):string;
var s:string;
begin
	str(a:n,s);
	fstr:=s;
end;

function ffstr(a:string;n:byte):string;
begin
	while length(a)<n do a:=' '+a;
	ffstr:=a;
end;

{ sortie d'un texte sur l'cran sans passer par le bios: voir keypressed }
procedure FWrite(x,y,co:integer;s:string);
var	i,adr:word;
begin
	adr:=(y-1)*160+((x-1) shl 1);
	co:=co shl 8;
	for i:=1 to length(s) do begin
		memW[$B800:adr]:=word(s[i]) or co;
		inc(adr,2);
	end;
end;

procedure DrawBar(x,y,h,v:integer);
var i:integer;
	a,c,adr:word;

begin
	adr:=160*(y-1)+(x-1)*2;
	v:=(v*h) shr 5;
	if (v and 1)=0 then c:=ord('')+$0F00 else c:=ord('')+$0F00;
	v:=v shr 1;
	for i:=0 to h-1 do begin
		if i<v then a:=ord('')+$0F00
		else if i=v then a:=c
		else a:=ord(' ')+$0F00;
		memW[$B800:adr]:=a;
		dec(adr,160);
	end;
end;


{ modification de l'affichage suivant RS }
procedure UpdateState;
var s,t:string;
	a:integer;
begin
	GetRPMStatus(RS);
	for i:=0 to 7 do with RS.Voice[i] do begin
		s:=fstr(i+1,2)+': ';
		if ok<>0 then t:='ON  ' else t:='OFF ';
		s:=s+t;
		if (instr>0) and (Module.SampleName<>nil) then t:=Module.SampleName^[instr-1] else t:='';
      s:=s+ffstr(t,25)+' '+fstr(vol,3)+' T='+fstr(period,5);
		FWrite(1,stateline+i,Yellow,s);
		DrawBar((i shl 1)+60,stateline+10,10,bar);
	end;

	s:='NbPat: '+fstr(RS.patidx,3)+'  Pat: '+fstr(RS.pat,3)+
		'  Ligne: '+fstr(RS.patpos,3)+'  Speed: '+fstr(RS.Speed,3);
	Fwrite(1,stateline+9,Red,s);
	s:='volout: '+fstr(RS.volout,3)+' balance: '+fstr(RS.balance,3);
	Fwrite(1,stateline+10,Red,s);
end;

procedure MakePlayerScreen;
begin
	ClrScr;
	TextColor(LightGray);
	writeln('[S]                 DOS SHELL');
	writeln('[+,-]               Volume');
	writeln('[*,/]               Balance');
	writeln('[left,right arrow]  Skip pattern');
	writeln('[F1..F8]            Voices on/off');
	writeln('[ESC]               End');
	writeln('Title :',module.modtitle);
end;

{ gestion de la mmoire pour SoundDRV }
function myMalloc(len:word):pointer; far;
var p:pointer;
begin
	if (len>MaxAvail) then begin
		MyMalloc:=nil;
	end
	else begin
		getmem(p,len);
		MyMalloc:=p;
	end;
end;

procedure myFree(p:pointer;len:word); far;
begin
	freemem(p,len);
end;

begin
	Writeln('PLAYP.EXE (SoundDRV example) Pascal Module Player');
	Writeln;

	err:=InitDsound;
	if err<>0 then Error('Driver SNDDRV not found');

{ premire possibilit pour grer la RAM: }
	SetDSMemProc(myMalloc,myFree);

{	seconde possibilit moins jolie mais quelquefois utile si le langage n'a
	pas de gestionnaire de RAM dynamique. Le problme c'est qu'elle mobilise
	un bloc de mmoire uniquement pour DSOUND.
	On assume ici que Maxavail donne la place libre aprs HeapPtr, ce qui
	n'est pas toujours le cas. Comme on est en dbut de programme, a va.
}
{
	SetDSMemPtr(HeapPtr,MaxAvail);
	writeln('RAM libre pour DSOUND=',GetDSMemSize);
}

{ demande des paramtres }
	if paramcount<>3 then begin

     	Write('Name of MOD file: ');
     	readln(nommod);
		Write('Frequency: ');
		readln(freq);

		GetCardGlobalInfo(CGINF);

		Writeln('Supported Cards: ');
		for i:=0 to CGINF.NbCard-1 do begin
               CINF.CardType:=i;
			err:=GetCardInfo(CINF);
			with CINF do begin
				writeln(' [',i:2,'] ',CardName);
				writeln('     from ',OutFreqMin,
					' to ',OutFreqMax,
					' Hz (',OutFreqBest,
					' Hz here)  Found on PC:',onpcstr[CardOnPC] );
			end;
		end;
		writeln('(Best card found: ',CGINF.BestCard,')');
		Write('Card: ');
		readln(ctype);
     end
	else begin
          nommod:=paramstr(1);
          val(paramstr(2),freq,err);
          if err<>0 then Error('Frequency Error');
          val(paramstr(3),ctype,err);
          if err<>0 then Error('Card Number Error');
	end;

	if pos('.',nommod)=0 then nommod:=nommod+'.MOD';

	writeln('Loading Module...');
	err:=LoadMod(Module,nommod);
	if err<>0 then Error('Loading of mod file failed');

{ Pour les tests: }
{
	for i:=0 to Module.NbSample-1 do begin
		with Module.Sample^[i] do begin
			writeln(i:3,' len: ',SplSize:5,
				' vol:',SplVol:2,' rlen:',SplRepLen:5,' radr:',SplRepAdr:5);
		end;
	end;
	k:=getkey;
}

	MakePlayerScreen;

	with DSInfo do begin
		CardType:=ctype;
		CardData:=0;
		SampleFreq:=freq;
	end;
	err:=StartRPMod(DSinfo,Module);
	if err<>0 then Error('Error RPMOD');

	fin:=0;
	repeat
		UpdateState;
		if keypressed then begin
			k:=getkey;
			case k of
			59*256..68*256: begin
				v:=hi(k)-59;
				SetRPMVoice(v,1-RS.voice[v].ok);
			end;
			27: begin
				fin:=1;
			end;
			ord('+'): begin
				SetRPMVolOut(RS.volout+1,RS.Balance);
			end;
			ord('-'): begin
				SetRPMVolOut(RS.volout-1,RS.Balance);
			end;
			ord('/'): begin
				SetRPMVolOut(RS.volout,RS.Balance-1);
			end;
			ord('*'): begin
				SetRPMVolOut(RS.volout,RS.Balance+1);
			end;
     		ord('K')*256: begin
				SetRPMPattern(RS.patidx-1);
			end;
     		ord('M')*256: begin
				SetRPMPattern(RS.patidx+1);
			end;
			ord('S'),ord('s'): begin
				ClrScr;
				DosShell;
				MakePlayerScreen;
			end;
			end;
		end;
{ si pour une raison ou pour une autre, le son a t arrt, c'est avec cette
  fonction que l'on peut le dtecter. Mais attention: il faut quand mme
  appeler StopRPMod dans ce cas !!
}
		case GetDSoundStatus of
		DSST_SOUNDSTOPPED: fin:=1;
		DSST_SOUNDERROR: fin:=2;
		end;
	until fin<>0;

	err:=StopRPMod;
	FreeMod(module);
	ClrScr;
	writeln('End.');
	if err<>0 then Error('Error RPMOD');
	if fin=2 then Error('Too high frequency !');
end.

