/*		Exemple d'un petit player de modules en Turbo C
		par F.Bellard pour ESAT Software
		TAB=3 SPACES
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "sounddrv.h"

/* message d'erreur */
void Error(char *s)
{
	printf("Erreur fatale: %s\n",s);
	exit(EXIT_FAILURE);
}	


/* routines de gestion mmoire utilises par sounddrv */

void * far pascal SndMalloc(WORD len)
{
	return malloc(len);
}

void far pascal SndFree(void *pt,WORD len)
{
	free(pt);
}


/* Fonction kbhit modifie pour ne pas faire de parasites durant la sortie
	sur le hautparleur (sur les autres cartes, cela n'est pas utile). Ces
	parasites proviennent du fait que lors de l'appel d'une fonction du bios
	les interruptions sont inhibes trop longtemps, ce qui gne la reproduction
	sur le hautparleur.
*/
int snd_kbhit()
{
	return peek(0x0040,0x001A)!=peek(0x0040,0x001C) && kbhit();
}

/* idem pour printf */
void snd_puts(int x,int y,int co,char *s)
{
	WORD *p;
	p=MK_FP(0xB800,(y-1)*160+((x-1)<<1));
	co<<=8;
	while (*s) *p++=((BYTE)(*s++))|(WORD)co;
}


int main(int argc,char *argv[]) 
{
	int e;
	DSOUNDINFO ds;
	RPMMODULE m;
	CARDINFO cinf;
	CARDGLOBALINFO cginf;
	RPMSTATUS st;
	WORD freq;
	char name[80];
	char cname[40];
	char buf[100];
	struct text_info tinf;

	printf("Exemple de player de modules en C\nPar F.Bellard (c) 1993 ESAT Software\n\n");
	if (argc!=2) {
		printf("Syntaxe: PLAYC nom_du_module\n\n");
		return EXIT_SUCCESS;
	}
	
	/* Initialisation des routines sonores */
	if (InitDSound()!=0) Error("Driver sonore non charg");
	SetDSMemProc(SndMalloc,SndFree);

	/* conversion de la chaine argv[1] au format pascal */
	name[0]=strlen(argv[1]);
	strcpy(name+1,argv[1]);

	/* chargement du module */
	if (LoadMod(&m,name)!=0) Error("Module incorrect");
			
	/* Dtermination du nombre de cartes et de la meilleure carte */
	GetCardGlobalInfo(&cginf);
	cinf.CardType=cginf.BestCard;
	GetCardInfo(&cinf);
	memcpy(cname,cinf.CardName+1,cinf.CardName[0]);
	cname[cinf.CardName[0]]=0;
	printf("%s  %u Hz\n\n",cname,cinf.outFreqBest);
		
	/* On lance le module */
	ds.CardType=cinf.CardType;
	ds.CardData=0;
	ds.SampleFreq=cinf.outFreqBest;

	if (StartRPMod(&ds,&m)!=0) Error("Erreur au lancement du player");
			
	gettextinfo(&tinf);
	while ( (!snd_kbhit()) && ((e=GetDSoundStatus())==DSST_SOUND) ) {
		/* Affichage de quelques valeurs intressantes */
		GetRPMStatus(&st);
		sprintf(buf,"Squence:%3d Pattern:%3d ligne:%3d",st.PatIdx,st.Pat,st.PatPos);
		snd_puts(tinf.curx,tinf.cury,tinf.attribute,buf);
	}
	if (kbhit()) getch();
	printf("\n");	
	StopRPMod();
	FreeMod(&m);
	if (e==DSST_SOUNDERROR) Error("Frquence trop leve");
	return EXIT_SUCCESS;
}